// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <OmniBase/OBObject.h>

@class NSArray, NSMutableArray;
@class ONHostAddress;

@interface ONHost : OBObject
{
    NSString *hostname;
    NSString *canonicalHostname;
    NSMutableArray *addresses;
}

+ (NSString *)domainName;
+ (NSString *)localHostname;

+ (ONHost *)hostForHostname:(NSString *)hostname;
+ (ONHost *)hostForAddress:(ONHostAddress *)anAddress;

- (NSString *)hostname;
- (NSArray *)addresses;
- (NSString *)canonicalHostname;
- (NSString *)domainName;

@end

#import "FrameworkDefines.h"

// Exceptions which may be raised by this class
OmniNetworking_EXTERN NSString *ONHostNotFoundExceptionName;
OmniNetworking_EXTERN NSString *ONHostNameLookupErrorExceptionName;
OmniNetworking_EXTERN NSString *ONHostHasNoAddressesExceptionName;
OmniNetworking_EXTERN NSString *ONGetHostByNameNotFoundExceptionName;
