// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <objc/objc.h>
#import <objc/objc-class.h>
#import <objc/objc-runtime.h>
#import "FrameworkDefines.h"

@class NSObject, NSString, NSDictionary;

#ifndef NO_INLINE
#define OFUtilities_INLINE inline
#else
#define OFUtilities_INLINE
#endif // NO_INLINE

OmniFoundation_EXTERN void OFSetIvar(NSObject *object, NSString *ivarName, NSObject *ivarValue);
OmniFoundation_EXTERN NSObject *OFGetIvar(NSObject *object, NSString *ivarName);

// Makes NSCoding methods simpler.
#define OMNI_ENCODE(coder, var) [coder encodeValueOfObjCType: @encode(typeof(var)) at: &(var)];
#define OMNI_DECODE(coder, var) [coder decodeValueOfObjCType: @encode(typeof(var)) at: &(var)];

// This returns the root class for the class tree of which aClass is a member.
static OFUtilities_INLINE Class OFRootClassForClass(Class aClass)
{
    while (aClass->super_class)
	aClass = aClass->super_class;
    return aClass;
}

OmniFoundation_EXTERN BOOL OFInstanceIsKindOfClass(id instance, Class aClass);

OmniFoundation_EXTERN NSString *OFDescriptionForObject(id object, NSDictionary *locale, unsigned indentLevel);
 // This function returns a pointer to a string that can be used to uniquely identify an object, be it an instance or a class.  We define that this function only works for classes that have names shorter than OF_MAX_CLASS_NAME_LEN.  This pointer passed to this function must contain at least this much space.

#define OF_MAX_CLASS_NAME_LEN (256)
OmniFoundation_EXTERN char *OFNameForPointer(id object, char *pointerName);

#if 0 // alloca() is weird, I'll just use the old behavior for now
#define OFStackAllocatedNameForPointer(object) \
	OFNameForPointer(object, alloca(OF_MAX_CLASS_NAME_LEN))
#else
OmniFoundation_EXTERN char *OFStackAllocatedNameForPointer(id object);
#endif
