// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import "OFObject.h"

@class NSMutableArray, NSArray, NSData;

@interface OFUserDefaults : OFObject
{
    NSString *ownerName;
    NSMutableArray      *unresolvedKeys;
    NSMutableDictionary *defaultsDictionary;
    NSMutableDictionary *globalDefaultsDictionary;
    NSMutableDictionary *registrationDictionary;
    NSMutableDictionary *overrideNetworkDictionary;
    NSMutableDictionary *advisoryNetworkDictionary;
    unsigned int changeCount;
}

+ (OFUserDefaults *)sharedUserDefaults;

- (void)setOwnerName:(NSString *)ownerName;
- (NSString *)ownerName;

- (void)readDefaultsDatabase;

- (NSDictionary *)defaultsDictionary;
- (NSDictionary *)registrationDictionary;
- (NSDictionary *)overrideNetworkDictionary;
- (NSDictionary *)advisoryNetworkDictionary;
- (unsigned int)changeCount;

- (BOOL)defaultRegisteredForKey:(NSString *)defaultName;
- (id)objectForKey:(NSString *)defaultName;

- (NSArray *)arrayForKey:(NSString *)defaultName;
- (BOOL)boolForKey:(NSString *)defaultName;
- (NSData *)dataForKey:(NSString *)defaultName;
- (NSDictionary *)dictionaryForKey:(NSString *)defaultName;
- (float)floatForKey:(NSString *)defaultName;
- (int)integerForKey:(NSString *)defaultName;
- (NSArray *)stringArrayForKey:(NSString *)defaultName;
- (NSString *)stringForKey:(NSString *)defaultName;

- (void)removeObjectForKey:(NSString *)defaultName;

- (void)setObject:(id)value forKey:(NSString *)defaultName;

- (void)setBool:(BOOL)value forKey:(NSString *)defaultName;
- (void)setFloat:(float)value forKey:(NSString *)defaultName;
- (void)setInteger:(int)value forKey:(NSString *)defaultName;

- (void)registerDefaults:(NSDictionary *)dictionary;	

@end

#import "FrameworkDefines.h"

OmniFoundation_EXTERN NSString *OFUserDefaultsNotRegisteredException;
