// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import "OFObject.h"

// An array of OFStaticObjects of a particular class, with efficient allocation and deallocation

#ifndef WIN32
#define OFStaticArray_USE_NSDATA
#endif

@class NSMutableData;

@interface OFStaticArray : OFObject
{
    Class objectClass;
    unsigned int objectLength;
    unsigned int count;
    unsigned int capacity;
    unsigned int extensionSize;
    void *mutableBytes;
#ifdef OFStaticArray_USE_NSDATA
    NSMutableData *data;
#endif
}

- initWithClass:(Class)aClass capacity:(unsigned int)aCapacity extendBy:(unsigned int)extendBy;
- initWithClass:(Class)aClass capacity:(unsigned int)aCapacity;
- initWithClass:(Class)aClass;

- (unsigned int)capacity;
- (void)setCapacity:(unsigned int)aCapacity;

- (unsigned int)extensionSize;
- (void)setExtensionSize:(unsigned int)anAmount;

- (unsigned int)count;
- (void)setCount:(unsigned int)number;
- (void)removeAllObjects;

- (id)newObject;
- (id)objectAtIndex:(unsigned int)anIndex;

@end
