// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// private $Header$

#import <Foundation/NSZone.h>
#import <objc/objc.h>

#import "FrameworkDefines.h"

typedef struct {
    NSZone                     *stackZone;
    void                       *stackRoot;
    unsigned long               basePointer;
    unsigned long               stackPointer;
    unsigned long               stackSize;
    unsigned long               currentFrameSize;
    unsigned long               frameCount;
} OFStack;


#define OMNI_TYPE_OP(cType, strType)								\
        OmniFoundation_EXTERN void OFStackPush ## strType (OFStack *stack, cType aVal);         \
        OmniFoundation_EXTERN void OFStackPop ## strType (OFStack *stack, cType *aVal);         \
        OmniFoundation_EXTERN void OFStackPeek ## strType (OFStack *stack,			\
                                                             unsigned long basePointer,		\
                                                             int offset, cType *aVal);		\
        OmniFoundation_EXTERN void OFStackPoke ## strType (OFStack *stack,			\
                                                             unsigned long basePointer,		\
                                                             int offset, cType aVal);

OMNI_TYPE_OP(unsigned long, UnsignedLong)
OMNI_TYPE_OP(id,            Id)
OMNI_TYPE_OP(SEL,           SEL)
OMNI_TYPE_OP(void *,        Pointer)

#undef OMNI_TYPE_OP

OmniFoundation_EXTERN void OFStackDebug(BOOL enableStackDebugging);

OmniFoundation_EXTERN OFStack *OFStackAllocate(NSZone *zone);
OmniFoundation_EXTERN void OFStackDeallocate(OFStack *stack);

OmniFoundation_EXTERN void OFStackPushBytes(OFStack *stack,
                                            const void *bytes,
                                            unsigned long size);
OmniFoundation_EXTERN void OFStackPopBytes(OFStack *stack,
                                           void *bytes,
                                           unsigned long size);

OmniFoundation_EXTERN void OFStackPushFrame(OFStack *stack);
OmniFoundation_EXTERN void OFStackPopFrame(OFStack *stack);

/* Advanced features */
OmniFoundation_EXTERN unsigned long OFStackPreviousFrame(OFStack *stack, unsigned long framePointer);
OmniFoundation_EXTERN void          OFStackDiscardBytes(OFStack *stack, unsigned long size);
OmniFoundation_EXTERN void          OFStackPrint(OFStack *stack);

