// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// private $Header$

#define OFSimpleLockDefined

// TODO: Verify that OFSimpleLock actually works correctly on PDO Solaris

extern void pthread_mutex_init(), pthread_mutex_destroy();
extern void pthread_mutex_lock(), pthread_mutex_trylock();
extern void pthread_mutex_unlock();

typedef void *OFSimpleLockType;

static inline void OFSimpleLockInit(OFSimpleLockType *simpleLock)
{
    // Only allow mutexing within this process
    pthread_mutex_init(simpleLock, NULL);
}

static inline void OFSimpleLockFree(OFSimpleLockType *simpleLock)
{
    pthread_mutex_destroy(simpleLock);
}

static inline void OFSimpleLock(OFSimpleLockType *simpleLock)
{
    pthread_mutex_lock(simpleLock);
}

static inline void OFSimpleLockTry(OFSimpleLockType *simpleLock)
{
    pthread_mutex_trylock(simpleLock);
}

static inline void OFSimpleUnlock(OFSimpleLockType *simpleLock)
{
    pthread_mutex_unlock(simpleLock);
}
