// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// public $Header$

#import "OFObject.h"

@class NSDate, NSRecursiveLock, NSMutableArray, NSTimer;
@class OFInvocation, OFScheduledEvent;

#import <Foundation/NSDate.h> // For NSTimeInterval

@interface OFScheduler : OFObject
{
    NSTimer                    *alarmTimer;

    NSMutableArray             *scheduleQueue;
    NSRecursiveLock            *scheduleLock;
}

+ (OFScheduler *)mainScheduler;

- (OFScheduledEvent *)scheduleInvocation:(OFInvocation *)anInvocation atDate:(NSDate *)date;
- (OFScheduledEvent *)scheduleInvocation:(OFInvocation *)anInvocation afterTime:(NSTimeInterval)time;

- (OFScheduledEvent *)scheduleSelector:(SEL)selector onObject:(id)anObject withObject:(id)anArgument atDate:(NSDate *)date;
- (OFScheduledEvent *)scheduleSelector:(SEL)selector onObject:(id)anObject withObject:(id)anArgument afterTime:(NSTimeInterval)time;

- (void)abortEvent:(OFScheduledEvent *)anEvent;
- (void)abortSchedule;

- (OFScheduler *)subScheduler;

@end
