// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// private $Header$

#import "OFObject.h"
#import <Foundation/NSString.h>

typedef enum {
    OpEnd, OpStartOfLine, OpEndOfLine, OpAnyCharacter, OpAnyOfString, OpAnyButString, OpBranch, OpBack, OpExactlyString, OpNothing, OpZeroOrMore, OpOneOrMore, OpOpen, OpClose
} ExpressionOpCode;

typedef struct {
    ExpressionOpCode opCode	: 4;
    unsigned int argumentNumber	: 12;
    unsigned int nextState	: 16;
} ExpressionState;

@class OFStringScanner, OFRegularExpressionMatch;

@interface OFRegularExpression : OFObject
{
    NSString *patternString;
    unichar startCharacter;
    BOOL matchStartsLine;
    unichar *matchString;
    unsigned int matchLength;
    unsigned int subExpressionCount;
    ExpressionState *program;
    unichar *stringBuffer;
}

- initWithString:(NSString *)string;

- (OFRegularExpressionMatch *)matchInString:(NSString *)string;
- (OFRegularExpressionMatch *)matchInScanner:(OFStringScanner *)scanner;

@end
