// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// private $Header$

#import "OFObject.h"
#import "FrameworkDefines.h"

// Some platforms don't provide random number generation and of those that do, there are many different variants.  We provide a common random number generator rather than have to deal with each platform independantly.  Additionally, we allow the user to maintain several random number generators.

typedef struct {
    unsigned long y; // current value any number between zero and M-1
} OFRandomState;

OmniFoundation_EXTERN OFRandomState OFDefaultRandomState;
// This random state will automatically be seeded at startup.  This initialization will occur during +[OBPostLoader processClasses].  The default random state should not be used before this method has completed.

OmniFoundation_EXTERN void OFRandomSeed(OFRandomState *state, unsigned long y);
OmniFoundation_EXTERN unsigned long OFRandomNextState(OFRandomState *state);

#define OFRandomNext() OFRandomNextState(&OFDefaultRandomState)
