// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import "OFObject.h"

@class NSLock;
@class OFInvocation, OFMessageQueue;

@interface OFQueueProcessor : OFObject
{
    OFMessageQueue *messageQueue;

    NSLock *currentInvocationLock;
    OFInvocation *currentInvocation;
}

- initForQueue:(OFMessageQueue *)aQueue;

- (void)processQueueUntilEmpty;
- (void)processQueueForever;
- (void)startProcessingQueueInNewThread;

- (OFInvocation *)retainedCurrentInvocation;

@end

