// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <Foundation/NSObject.h>
#import <mach/cthreads.h>

@interface OFQueue : NSObject
{
    BOOL closed;
    id *objects;
    unsigned int max, count, head, tail;
    mutex_t mutex;
    condition_t condition;
}

- initWithCount:(unsigned int)maxCount;

- (unsigned int)maxCount;
- (unsigned int)count;

- (BOOL)isClosed;
- (void)close;

- (id)dequeueShouldWait:(BOOL)wait;
- (BOOL)enqueue:(id)anObject shouldWait:(BOOL)wait;

@end
