// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import "OFObject.h"

#import <Foundation/NSData.h>

#define OFOID_LENGTH (12)

// OFOid is a concrete subclass of NSData that automatically generates globally unique bytes each time an instance is generated.  This is a subclass of NSData to allow for efficient use with EOF.
@interface OFOid : NSData
{
@public
    unsigned char bytes[OFOID_LENGTH];
}

+ (OFOid *)oid;
+ (OFOid *)zeroOid;

- initWithBytes:(const void *)bytes length:(unsigned int)length;
- initWithString:(NSString *)string;
- (const void *)bytes;
- (unsigned int)length;

- (NSString *)sqlString;
- (BOOL)isZero;

- (NSString *)description;
    // Returns a '0x' prefixed hex string appropriate for entry into SQL

@end

// EOF2.2 has a bug in that custom value primary keys are sent -intValue even if they aren't subclasses of NSNumber.  EOF is just using this to see if the key is null (and interpreting zero NSNumbers as null).  We just return 1 from this method and assume that the return value is never used.
@interface OFOid (EOF2_2_BugFix)
- (int)intValue;
@end
