// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <Foundation/NSArray.h>

typedef struct {
    unsigned int value;
    NSObject *object;
} heapNode_t;

@interface OFHeap : NSObject
{
    heapNode_t *contents;
    unsigned int size, capacity;
}

- initWithCapacity:(unsigned int)newCapacity;

- (void)addObject:(NSObject *)anObject value:(unsigned int)aValue;

- (NSObject *)removeObject;
- (NSObject *)removeObjectWithValueLessThan:(unsigned int)aValue;

- (NSObject *)peekObject;
- (unsigned int)peekValue;

@end
