// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import "OFObject.h"

@class NSCalendarDate, NSNumber;
@class OFDirectory;

@interface OFFile : OFObject
{
    OFDirectory *directory;
    NSString *name;
    NSString *path;
}

+ fileWithDirectory:(OFDirectory *)aDirectory name:(NSString *)aName;
+ fileWithPath:(NSString *)aPath;

- initWithDirectory:(OFDirectory *)aDirectory name:(NSString *)aName;
- initWithPath:(NSString *)aPath;

- (NSString *)name;
- (NSString *)path;

- (BOOL)isDirectory;
- (BOOL)isShortcut;
- (NSNumber *)size;
- (NSCalendarDate *)lastChanged;

@end

@interface OFMutableFile : OFFile
{
    struct {
        unsigned int isDirectory:1;
        unsigned int isShortcut:1;
    } flags;
    NSNumber *size;
    NSCalendarDate *lastChanged;
}

- (void)setIsDirectory:(BOOL)shouldBeDirectory;
- (void)setIsShortcut:(BOOL)shouldBeShortcut;
- (void)setSize:(NSNumber *)aSize;
- (void)setLastChanged:(NSCalendarDate *)aDate;
- (void)setPath:(NSString *)aPath;

@end
