// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import "OFObject.h"

#ifdef FAST_BUGGY_WAY
#import <mach/cthreads.h>
#endif

@class NSConditionLock;

@interface OFCondition : OFObject
{
#ifdef FAST_BUGGY_WAY
    struct condition machCondition;
    struct mutex machMutex;
    unsigned int signalCount;
#else
    NSConditionLock *lock;
    struct {
        unsigned int cleared:1;
    } flags;
#endif
}

- init;

- (void)waitForCondition;

- (void)signalCondition;
- (void)broadcastCondition;

- (void)clearCondition;

@end
