// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <Foundation/NSThread.h>

@interface NSThread (OFExtensions)

+ (void)setMainThread;
+ (NSThread *)mainThread;
+ (BOOL)inMainThread;
+ (BOOL)mainThreadOpsOK;   // returns true if we are the main thread *or* if we have locked the main thread

// For putting appkit stuff into subthreads without shipping data back and forth.  If you don't need the return value, then queuing a selector is much more efficient than this.
+ (void)lockMainThread;
+ (void)unlockMainThread;

- (void)yield;
    // Causes the thread to possibly stop executing and cause another thread to start executing.  Has no effect if not multithreaded.

- (void)setName:(NSString *)aName;
    // Sets the thread's name (useful for debugging)

@end

#define ASSERT_IN_MAIN_THREAD(reason) NSAssert([NSThread inMainThread], reason)
#define ASSERT_MAIN_THREAD_OPS_OK(reason) NSAssert([NSThread mainThreadOpsOK], reason)
