// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <Foundation/NSString.h>

@interface NSString (OFExtensions)
+ (NSString *)stringWithData:(NSData *)data encoding:(NSStringEncoding)encoding;
+ (NSString *)abbreviatedStringForBytes:(unsigned long long)bytes;
+ (NSString *)spacesOfLength:(unsigned int)aLength;
+ (NSString *)stringWithCharacter:(unichar)aCharacter;

// These methods return strings containing the indicated character

+ (NSString *)horizontalEllipsisString; // '...'
+ (NSString *)leftPointingDoubleAngleQuotationMarkString; // '<<'
+ (NSString *)rightPointingDoubleAngleQuotationMarkString; // '>>'
+ (NSString *)emdashString; // '--'

- (BOOL)containsCharacterInSet:(NSCharacterSet *)searchSet;
- (BOOL)containsString:(NSString *)searchString options:(unsigned int)mask;
- (BOOL)containsString:(NSString *)searchString;
- (BOOL)isEqualToCString:(const char *)cString;
- (BOOL)hasLeadingWhitespace;
- (unsigned int)hexValue;
- (NSString *)stringByRemovingSurroundingWhitespace;
    // Note: this may return the same NSString instance
- (NSString *)stringByCollapsingWhitespaceAndRemovingSurroundingWhitespace;
- (NSString *)stringByRemovingReturns;
- (NSString *)stringByRemovingString:(NSString *)removeString;
- (NSString *)stringByPaddingToLength:(unsigned int)aLength;
- (NSString *)stringByNormalizingPath;
    // Normalizes a path like /a/b/c/../../d to /a/d.
    // Note: Does not work properly on Windows at the moment because it is hardcoded to use forward slashes rather than using the native path separator.
- (unichar)firstCharacter;
- (unichar)lastCharacter;
// - (NSString *)lowercaseSubstringFromRange:(NSRange)range;
- (NSString *)stringByReplacingCharactersInSet:(NSCharacterSet *)set withString:(NSString *)replaceString;
- (NSString *)stringByReplacingKeysInDictionary:(NSDictionary *)keywordDictionary startingDelimiter:(NSString *)startingDelimiterString endingDelimiter:(NSString *)endingDelimiterString;
    // Useful for turning $(NEXT_ROOT)/LocalLibrary into C:/Apple/LocalLibrary
- (NSRange)findString:(NSString *)string selectedRange:(NSRange)selectedRange options:(unsigned int)options wrap:(BOOL)wrap;

- (NSRange)rangeOfCharactersAtIndex:(unsigned)pos
                        delimitedBy:(NSCharacterSet *)delim;
- (NSRange)rangeOfWordContainingCharacter:(unsigned)pos;
- (NSRange)rangeOfWordsIntersectingRange:(NSRange)range;

#define OF_CHARACTER_BUFFER_SIZE 1024

#define StringStartLoopThroughCharacters(string, ch)			\
{									\
    unichar characterBuffer[OF_CHARACTER_BUFFER_SIZE];			\
    unsigned int charactersProcessed, length;				\
									\
    charactersProcessed = 0;						\
    length = [string length];						\
    while (charactersProcessed < length) {				\
        unsigned int charactersInThisBuffer;				\
        unichar *input;							\
									\
        charactersInThisBuffer = MIN(length - charactersProcessed, OF_CHARACTER_BUFFER_SIZE); \
        [string getCharacters:characterBuffer range:NSMakeRange(charactersProcessed, charactersInThisBuffer)]; \
        charactersProcessed += charactersInThisBuffer;			\
        input = characterBuffer;					\
									\
        while (charactersInThisBuffer--) {				\
            unichar ch = *input++;


#define StringEndLoopThroughCharacters	 				\
        }								\
    }									\
}


@end
