// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <Foundation/NSDictionary.h>

@interface NSMutableDictionary (OFExtensions)
- (void)setObject:(id)anObject forKeys:(NSArray *)keys;

// These are nice for ease of use
- (void)setFloatValue:(float)value forKey:(NSString *)key;
- (void)setDoubleValue:(double)value forKey:(NSString *)key;
- (void)setIntValue:(int)value forKey:(NSString *)key;
- (void)setBoolValue:(BOOL)value forKey:(NSString *)key;

// Setting with defaults
- (void)setObject:(id)object forKey:(id)key defaultObject:(id)defaultObject;
- (void)setFloatValue:(float)value forKey:(id)key defaultValue:(float)defaultValue;
- (void)setDoubleValue:(double)value forKey:(id)key defaultValue:(double)defaultValue;
- (void)setIntValue:(int)value forKey:(id)key defaultValue:(int)defaultValue;
- (void)setBoolValue:(BOOL)value forKey:(id)key defaultValue:(BOOL)defaultValue;

@end
