// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// private $Header$ */

#import <Foundation/NSDictionary.h>

#import "OFDictionaryInitialization.h"
#import "FrameworkDefines.h"

OmniFoundation_EXTERN NSString *OmniDictionaryElementNameKey;

@interface NSDictionary (OFExtensions)

- (id)anyObject;
- (NSDictionary *)elementsAsInstancesOfClass:(Class)aClass withContext:(id)context;
- (NSString *)keyForObjectEqualTo:(id)anObj;

// ObjC doesn't return 0.0 if you send a message returning float or double to a nil
- (float)floatForKey:(NSString *)key defaultValue:(float)defaultValue;
- (float)floatForKey:(NSString *)key;
- (double)doubleForKey:(NSString *)key defaultValue:(double)defaultValue;
- (double)doubleForKey:(NSString *)key;

// Returns YES iff the value is YES, Y, yes, y, or 1.
- (BOOL)boolForKey:(NSString *)key defaultValue:(BOOL)defaultValue;
- (BOOL)boolForKey:(NSString *)key;

// Just to make life easier
- (int)intForKey:(NSString *)key defaultValue:(int)defaultValue;
- (int)intForKey:(NSString *)key;

// This seems more convenient that having to write your own if statment a zillion times
- (id)objectForKey:(NSString *)key defaultObject:(id)defaultObject;

- (id)deepMutableCopy;

@end
