// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <Foundation/NSData.h>

@interface NSData (OFExtensions)

+ (NSData *)randomDataOfLength:(unsigned int)length;
// Returns a new autoreleased instance that contains the number of requested random bytes.

+ (id)dataWithHexString:(NSString *)hexString;
- initWithHexString:(NSString *)hexString;
- (NSString *)lowercaseHexString;

- initWithASCII85String: (NSString *) ascii85String;
- (NSString *)ascii85String;

+ (id)dataWithBase64String:(NSString *)base64String;
- initWithBase64String:(NSString *)base64String;
- (NSString *)base64String;

- (unsigned long)indexOfFirstNonZeroByte;
    // Returns the index of the first non-zero byte in the receiver, or NSNotFound if if all the bytes in the data are zero.

- (NSData *)sha1Signature;
    // Uses the SHA-1 algorithm to compute a signature for the receiver.  Obviously, due to the dynamic nature of ObjC, and due to the fact that users will get access to the binary, this cannot be depended upon as an absolutely secure licensing mechanism, but this will prevent users from accidentally breaking the licensing agreement, which is really all we can hope for.

- (BOOL)writeToFile:(NSString *)path atomically:(BOOL)useAuxiliaryFile createDirectories:(BOOL)shouldCreateDirectories;
    // Will raise an exception if it can't create the required directories.

@end
