// Copyright 1997 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <Foundation/NSArray.h>

#import "OFDictionaryInitialization.h"

@interface NSArray (OFExtensions)

- (id)anyObject;
    // Returns any object from the array.

- (NSArray *)elementsAsInstancesOfClass:(Class)aClass withContext:(id)context;

#ifndef WINNT
- (id)randomObject;
    // Returns a random object from the array.
#endif

// These are safe to use on mixed-content arrays.
// The first two call -indexOfString:options:range: with default values.
- (int)indexOfString:(NSString *)aString;
- (int)indexOfString:(NSString *)aString options:(unsigned int)someOptions;
- (int)indexOfString:(NSString *)aString options:(unsigned int)someOptions 	range:(NSRange)aRange;

- (id)deepMutableCopy;

@end
