// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <Foundation/Foundation.h>

// We should NEVER use the BSD malloc functions since they don't
// report zone allocation statistics.  Typically, this is verified
// by OmniMake, but for third-party libraries that we don't want to
// make extensive source changes to, we can import this file.

#define malloc(size)                 NSZoneMalloc(NULL, size)
#define calloc(numElems, elemSize)   NSZoneCalloc(NULL, numElems, elemSize)
#define realloc(oldPointer, newSize) NSZoneRealloc(NULL, oldPointer, newSize)
#define free(pointer)                NSZoneFree(NULL, pointer)
