// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <Foundation/NSAutoreleasePool.h>

#if defined(sun) || defined(WINNT)


// The Solaris man page for errno says that it is thread safe.  Dunno how that could be.  Either they are refering to perror() and the other functions in the same page, or the -mt thread in the Solaris compiler can do something magic.
//
// On NT, errno is defined to be '(*_errno())' and presumably this function is thread safe.

#import <errno.h>
#define OMNI_ERRNO() errno

#else

#import <mach/cthreads.h>
#define OMNI_ERRNO() cthread_errno()

#endif

// It might be good to put some exception handling in this.

#define OMNI_POOL_START				\
do {						\
    NSAutoreleasePool *__pool;			\
    __pool = [[NSAutoreleasePool alloc] init];	\
    {

#define OMNI_POOL_END	\
    }			\
    [__pool release];	\
} while(0)

// This reraise() works in an NS_DURING block and can handle both old-style and new-style exceptions.

#ifndef sun // OpenStep/Solaris doesn't need this.
#define NS_RERAISE() _NXRaiseError(_localHandler.code, \
			_localHandler.data1, _localHandler.data2)
#endif
