// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import "OBObject.h"

// OBPostLoader provides the functionality that you might expect to get from implementing a +load method.  Unfortunately, some implementations of OpenStep (NT) have bugs with their  implementation of +load.  In particular, classes may or may not be registered with NSClassFromString, [NSBundle bundleForClass:] or other runtime information databases.  To work around this, this class listens for notifications from NSBundle about bundles having been loaded.  When a bundle is loaded, the classes in that bundle are examined for +didLoad method implementations.  If an implementation exists (and hasn't already been called), it is called with the bundle as the parameter.

// As a general rule of thumb, no class should implement +load:  instead, use +didLoad.

@interface OBPostLoader : OBObject

+ (void)processClasses;
    // This searches the class hierarchy for +didLoad implementations.  When it finds one that hasn't been called, it calls it.  Currently, there is no guarantee on the order that these messages will occur. This should be called as the first line of main().  Once this has been called at the beginning of main, it will automatically be called each time a bundle is loaded (view the NSBundle loading notification).

@end

@interface NSObject (OBPostLoader)

+ (void)didLoad;
    // This method will be called on every class (or category) which implements it.

@end
