// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <Foundation/Foundation.h>
#import <AppKit/NSView.h>

@interface OAThumbnailView : NSView
{
    NSArray	*thumbnails;
    NSSize	 maximumThumbnailSize;
    NSSize	 padding;
    int		 columnCount, rowCount;
    NSSize	 cellSize;
    float	 horizontalMargin;
    
    BOOL	 thumbnailsAreNumbered;
}

- (void)scrollSelectionToVisible;

- (void)setThumbnailsArray:(NSArray *)newThumbnailsArray;
- (NSArray *)thumbnailsArray;
- (void)sizeToFit;

- (void)setThumbnailsNumbered:(BOOL)bool;
- (BOOL)thumbnailsAreNumbered;

- (void)drawMissingThumbnailRect:(NSRect)rect;

@end


@protocol OmniThumbnailProvider
- (NSImage *)thumbnailImage;
- (void)missedThumbnailImageInView:(OAThumbnailView *)view
    rect:(NSRect)rect;
- (NSSize)thumbnailSize;
- (void)thumbnailWasSelected:(NSEvent *)event;
- (BOOL)isThumbnailSelected;
@end