// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <AppKit/NSView.h>

@class NSColor, NSFont;
@class OAProgressView;

@interface OAStatusView : NSView
{
    NSString *status;
    NSMutableDictionary *attributes;
    int ascenderHackAroundRhapsodyBug;

    OAProgressView *progressView;
    struct {
        unsigned int hasProgressView:1;
    } flags;
}

- (void)setFont:(NSFont *)aFont;
- (void)setColor:(NSColor *)aColor;

- (void)setStatus:(NSString *)aStatus;
- (void)setStatus:(NSString *)aStatus withProgress:(unsigned int)amount ofTotal:(unsigned int)total;

// for easy overriding in subclasses
- (void)drawBackground;
- (void)drawStatus;

@end
