// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// $Header$ */

#import <OmniFoundation/OFObject.h>

@class OAStatusView;
@class NSView, NSWindow;

#import "OAExtraWindowDrawingProtocol.h"
#import "OAStatusViewPositionProtocol.h"

@interface OAStatusDisplayer : OFObject <OAExtraWindowDrawing>
{
    NSView <OAStatusViewPosition> *viewToDisplayOver;
    OAStatusView *statusView;
    NSWindow *statusWindow, *bufferWindow;
    struct {
        unsigned int shouldDraw:1;
    } flags;
    NSRect statusRect;
}

- initForView:(NSView <OAStatusViewPosition> *)aView;

// API
- (void)setStatus:(NSString *)aStatus;
- (void)setStatus:(NSString *)aStatus withProgress:(unsigned int)amount ofTotal:(unsigned int)total;


@end
