// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <AppKit/NSScrollView.h>

@class NSButton, NSMenuItem, NSPopUpButton, NSTextField;

typedef enum { YES_SCROLL, NO_SCROLL, AUTO_SCROLL } ScrollingBehavior;

@interface OAScrollView : NSScrollView
{
    NSView                     *horizontalWidgetsBox;
    NSPopUpButton              *scalePopUpButton;
    NSButton                   *pageUpButton;
    NSButton                   *pageDownButton;
    NSTextField		       *pagePromptTextField;
    NSTextField		       *pageNumberTextField;
    NSTextField		       *pagesCountTextField;
    float                       zoomFactor;
    ScrollingBehavior           scrollBehavior;
    id			        delegate;
    struct {
        unsigned int			tiling:1;
    } flags;
}


- (void)zoomToScale:(double)newZoomFactor;
- (void)zoomFromSender:(NSMenuItem *)sender;
- (float)zoomFactor;
- (void)setDelegate:(id)newDelegate;
- (void)setScrollBehavior:(ScrollingBehavior)behavior;
- (void)showingPageNumber:(int)pageNumber of:(unsigned int)pagesCount;
- (void)gotoPage:(id)sender;

@end
