// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <OmniFoundation/OFObject.h>

@class NSMutableArray, NSMutableDictionary;
@class NSBox, NSImageView, NSTableView, NSTextField, NSWindow;
@class OAPreferenceClient, OAPreferenceController;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet

@interface OAPreferenceController : OFObject
{
    IBOutlet NSWindow *window;
    IBOutlet NSBox *box;
    IBOutlet NSTableView *tableView;
    IBOutlet NSTextField *titleTextField;
    IBOutlet NSImageView *imageView;

    NSString *categoryName;
    OAPreferenceClient *currentClient;
    NSMutableArray *clientRecordsArray;
    NSMutableDictionary *clientClassNamesToClientRecordDictionary;
    NSMutableDictionary *clientClassNamesToInstancesDictionary;
}

+ (OAPreferenceController *)sharedPreferenceControllerNamed:(NSString *)categoryName;
+ (OAPreferenceController *)sharedPreferenceController;

- initWithCategoryName:(NSString *)controllerCategoryName;

// API
- (OAPreferenceClient *)clientNamed:(NSString *)clientName;
- (void)close;

// Actions
- (IBAction)showPreferencesPanel:(id)sender;
- (IBAction)selectPreference:(NSTableView *)sender;
- (IBAction)restoreDefaults:(id)sender;


@end
