// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <AppKit/NSTableView.h>

// This provides a 'plus' button in the cornerView.  Clicking on the plus button allows the user to add columns.  Additionally, columns may be selected and removed from the display  by hitting the delete key.

@class NSMatrix, NSWindow;

@interface OAPlusTableView : NSTableView
{
    NSMutableArray *inactiveTableColumns;
    NSMatrix *popUpMatrix;
    NSWindow *popUpWindow;
}

- (NSArray *)inactiveTableColumns;

- (void)activateTableColumn:(NSTableColumn *)column;
- (void)inactivateTableColumn:(NSTableColumn *)column;
- (BOOL)isTableColumnActive:(NSTableColumn *)column;

- (void)addInactiveTableColumn:(NSTableColumn *)column;
- (void)removeInactiveTableColumn:(NSTableColumn *)column;

@end

@interface NSObject (OAPlusTableViewDelegate)
- (BOOL)tableView:(OAPlusTableView *)tableView shouldAllowActivationOfColumn:(NSTableColumn *)tableView;
@end
