// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

// This formatter provides for displaying a string value in a given font, color and alignment.

#import "OAOutlineFormatter.h"

@class NSFont;

#import <AppKit/NSText.h> // For NSTextAlignment

@interface OAOutlineTextFormatter : OAOutlineFormatter
{
    NSFont *font;
    NSColor *textColor;
    SEL stringValueSelector;
    id <NSObject> stringValueSelectorArgument;
    int alignment;
}

// Text attributes
- (void)setFont:(NSFont *)aFont;
- (void)setTextColor:(NSColor *)aColor;
- (void)setTextAlignment:(NSTextAlignment)alignment;

// These methods let you specify a selector to be used for getting a displayable string value from the object we are formatting
- (void)setValueSelector:(SEL)selector;
- (void)setValueSelector:(SEL)selector withObject:(id <NSObject>)anObject;

@end
