// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

// These protocols define the messages an entry in the outline view has to be able to handle.  In reality, you'll rarely (if ever) use anything but a subclass of OAOutlineFormatter (which already conforms to this protocol).

#import <Foundation/NSObject.h>

@class NSString;
@class NSEvent;
@class OAOutlineEntry;

#import <Foundation/NSGeometry.h> // For NSRect

// A basic formatter

@protocol OAOutlineFormatter <NSObject>

- (float)entryHeight:(OAOutlineEntry *)anEntry;

- (void)drawEntry:(OAOutlineEntry *)anEntry entryRect:(NSRect)rect selected:(BOOL)selected parent:(BOOL)parent hidden:(BOOL)hidden dragging:(BOOL)dragging;
    // The full rect of the entry is passed in as a convenience

- (void)trackMouse:(NSEvent *)event inRect:(NSRect)rect ofEntry:(OAOutlineEntry *)anEntry;

@end


// A formatter which supports find operations

@protocol OAOutlineFindableFormatter <OAOutlineFormatter>

- (BOOL)findString:(NSString *)string ignoreCase:(BOOL)ignoreCase forEntry:(OAOutlineEntry *)anEntry;

@end


// A formatter which has support for editing

@protocol OAOutlineEditableFormatter <OAOutlineFormatter>

- (void)editEntry:(OAOutlineEntry *)anEntry entryRect:(NSRect)rect;
    // The full rect of the entry is provided as a convenience.

- (BOOL)isEditable;

@end
