// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

// This is the formatter base class - it provides much of the functionality for a formatter. In most cases, you'll use a subclass of these, but you can create your own completely new formatter as long as it conforms to the OAOutlineFormatter protocol.

#import <OmniFoundation/OFObject.h>

@class NSEvent;

#import "OAOutlineFormatterProtocol.h"

@interface OAOutlineFormatter : OFObject <OAOutlineFormatter>
{
    float entrySpacing; // vertical space between entries
}

- (void)setEntrySpacing:(float)spacing;
- (float)entrySpacing;

- (float)buttonWidth;

- (void)mouseDown:(NSEvent *)event inRect:(NSRect)rect ofEntry:(OAOutlineEntry *)anEntry;
- (void)mouseUp:(NSEvent *)event inRect:(NSRect)rect ofEntry:(OAOutlineEntry *)anEntry;

- (void)drawSelectionForEntry:(OAOutlineEntry *)anEntry entryRect:(NSRect)rect;

@end
