// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

// This protocol defines the messages an entry in the outline view has to be able to handle. In reality, you'll rarely (if ever) use anything other than OAOutlineEntry itself.

#import <Foundation/NSObject.h>

@class NSEvent, NSPasteboard;
@class OAOutlineEntry;

#import <Foundation/NSGeometry.h> // For NSRect

@protocol OAOutlineEntry <NSObject>

- (float)entryHeight;

// entryRect is provided as a convenience - it's the rect of the entire OAOutlineEntry
- (void)drawRect:(NSRect)dirty entryRect:(NSRect)rect;

- (void)trackMouse:(NSEvent *)event inRect:(NSRect)rect ofEntry:(OAOutlineEntry *)anEntry;

@end
