// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <Foundation/NSObject.h>

@class NSView;

@protocol OAInspector <NSObject>

- (NSString *)inspectorName;
    // Will be used as window title, with " Document" after it.

- (void)inspectObject:(id)anObject;
    // The shared OAInspector instance calls this method on your inspectable controller once your inspector view is installed to let you actually inspect the object.

- (void)redisplay;
    // Called to redisplay the inspector.

- (NSView *)inspectorView;
    // Returns the view which OAInspector will swap into the Inspector window when your object is being inspected.

@end
