// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <OmniBase/OBObject.h>

@class NSBox, NSView, NSWindow;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet
#import "OAInspectableControllerProtocol.h"
#import "OAInspectorProtocol.h"

@interface OAInspector : OBObject
{
    IBOutlet NSWindow *inspectorWindow;
    IBOutlet NSBox *inspectorBox;
    IBOutlet NSBox *noInspectorBox;
    IBOutlet NSBox *multiInspectorBox;

    id <OAInspector, NSObject> currentInspector;
    NSView *currentInspectorView;

    BOOL isOnScreen;
}

+ (void)registerInspector:(id <OAInspector>)anInspector forClass:(Class)aClass;
+ (void)showInspector;

+ (id)multipleSelectionObject;

- (BOOL)isInspectorVisible;

@end

#import "FrameworkDefines.h"

OmniAppKit_EXTERN NSString *OAInspectorSelectionDidChangeNotification;
OmniAppKit_EXTERN NSString *OAInspectorShowInspectorDefaultKey;
