// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$

#import <OmniFoundation/OFObject.h>

@class NSButton, NSForm, NSWindow;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet
#import "OAFindControllerTargetProtocol.h"

@interface OAFindController : OFObject
{
    IBOutlet NSWindow *findPanel;
    IBOutlet NSForm *searchTextForm;
    IBOutlet NSButton *ignoreCaseButton;
    IBOutlet NSButton *findNextButton;
    IBOutlet NSButton *findPreviousButton;
}

// Menu actions

- (IBAction)showFindPanel:(id)sender;
- (IBAction)findNext:(id)sender;
- (IBAction)findPrevious:(id)sender;
- (IBAction)enterSelection:(id)sender;

// Panel actions

- (IBAction)_findNext:(id)sender;
    // This action is sent by findNextButton
- (IBAction)_findPrevious:(id)sender;
    // This action is sent by findPreviousButton
- (IBAction)_findNextAndClosePanel:(id)sender;
    // This action is called when you hit return in searchTextForm

// Utility methods
- (void)saveFindText:(NSString *)string;
- (NSString *)restoreFindText;
- (id <OAFindControllerTarget>)target;

@end
