// Copyright 1997-1998 Omni Development, Inc.  All rights reserved.
//
// $Header$ */

#import <Foundation/NSString.h>

#import <Foundation/NSGeometry.h> // For NSRect

@class NSColor, NSFont, NSTableColumn, NSTableView;

@interface NSString (OAExtensions)

// Used for displaying a file size in a tableview, which automatically abbreviates when the column gets too narrow.
+ (NSString *)possiblyAbbreviatedStringForBytes:(unsigned long long)bytes inTableView:(NSTableView *)tableView tableColumn:(NSTableColumn *)tableColumn;

// String drawing
- (void)drawWithFontAttributes:(NSDictionary *)attributes alignment:(int)alignment rectangle:(NSRect)rectangle;
- (void)drawWithFont:(NSFont *)font color:(NSColor *)color alignment:(int)alignment rectangle:(NSRect)rectangle;


@end
