/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Drawing.subproj/PDFView.h,v 1.2 1999/02/06 08:22:26 bungi Exp $ */

#import <AppKit/NSView.h>
#import <AppKit/NSNibDeclarations.h> // For IBAction

@class NSArray;
@class NSDictionary;
@class NSMutableDictionary;
@class NSString;
@class PDFXObject;
@class PDFFont;
@class PDFColorSpace;
@class PDFObject;
@class PDFPage;
@class PDFPageLays;
@class PDFStorage;
@class PDFDisplay;

#import <OmniAppKit/OAZoomableViewProtocol.h>
#import <OmniPDF/FrameworkDefines.h>

OmniPDF_EXTERN NSString *PDFViewBecameFirstResponderNotification;
OmniPDF_EXTERN NSString *PDFViewResignedFirstResponderNotification;

@interface PDFView : NSView <OAZoomableView>
{
    PDFDisplay                 *nonretainedPDFDisplay;

    NSMutableDictionary        *xrefToContextResourceDictionary;

    PDFPage		       *page;
    NSMutableDictionary        *pageColorSpaceDictionary;
    NSMutableDictionary        *pageFontDictionary;
    NSMutableDictionary        *pageXObjectDictionary;
    
    NSRect			displayBox;
    int				rotation;
    
    NSWindow		       *cache;
    NSView		       *cacheView;
    BOOL		        cacheIsValid;

    NSDPSContext	       *pdfContext;
    NSDPSContext	       *mainContext;
    
    float			zoomFactor;
    BOOL			shouldConstrainWindow;
    BOOL			canDraw;
    BOOL			drawLinks;
}

- initWithDisplay:(PDFDisplay *)newDisplay;

/* resources */
- (void)loadResourceDictionary:(NSDictionary *)aResourceDictionary;
- (PDFColorSpace *)colorSpaceForResourceName:(NSString *)resourceName;
- (PDFFont *)fontForResourceName:(NSString *)resourceName;
- (PDFXObject *)xObjectForResourceName:(NSString *)resourceName;

/* Drawing */
- (void)flushAndWaitContext:(NSDPSContext *)context;
- (void)downloadDefaultPS;
- (void)refreshCache;
- (void)usePDFContext: (BOOL) lockFocusOnCache;
- (void)useMainContext;

- (void)setCanDraw:(BOOL)yn;
- (BOOL)canDraw;

/* Public interface */
- (PDFDisplay *) pdfDisplay;
- (PDFStorage *) pdfStorage;

- (void)zoomTo:(float)zoom;
- (void)drawPage:(PDFPage *)newPage;
- (PDFPageLays *)readLaysForPage:(PDFPage *)newPage;

- (void) setShouldConstrainWindow: (BOOL) yn;
- (NSSize)maximumWindowSize;

- (BOOL)writeSelectionToPasteboard:(NSPasteboard *)pasteboard types:(NSArray *)types;

// Actions
- (IBAction)selectAll:(id)sender;
- (IBAction)copy:(id)sender;
- (IBAction)cut:(id)sender;
- (IBAction)showBookmarksPanel:(id)sender;
- (IBAction)showThumbnailsPanel:(id)sender;
- (IBAction)saveAsRTF:(id)sender;
- (IBAction)saveAsASCII:(id)sender;
- (IBAction)jumpToSelection:(id)sender;


@end
