/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Atoms.subproj/PDFStream.h,v 1.1 1999/02/03 10:25:32 bungi Exp $ */

#import <OmniPDF/PDFObject.h>


@interface PDFStream : PDFObject
{
    NSData                     *streamData;

    NSMutableDictionary        *dictionary;
    BOOL			isPacked;
    
    PDFArray                   *filterArray, *decodeParmsArray;
    BOOL			checkedDataForUnprintableCharacters;
    BOOL			dataContainsUnprintableCharacters;

    id <PDFSpecificEncryptionHandler,NSObject> decrypt;
}

- initWithData:(NSData *)pdfData
   offsetPointer:(unsigned *)scanOffsetPointer
   stack:(PDFArray *)stack;

- (void)parseFilters;

- (BOOL)unpack;
- (NSData *)unpackedData;
- (NSData *)data;
- (NSDictionary *)dictionary;
- (PDFArray *)filterArray;

- (int)filterCountMaybeAddHex;
- (void)writeFilterMaybeAddHexAtIndex:(int)filterIndex;
- (void)writeFiltersToPS;
- (void)writeFiltersMaybeAddHexToPS;
- (void)writeDataMaybeAddHexToPS;
- (void)writePackedDataToPSAsString;

- (void)executeInPS;

- (unsigned)streamDataLength;

@end
