// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/PDFStorage.h,v 1.1 1999/02/03 10:25:26 bungi Exp $

#import <OmniFoundation/OFObject.h>

#import <OmniPDF/PDFEncryptionHandlerProtocol.h>
#import <OmniPDF/FrameworkDefines.h>

@class NSMutableArray, NSArray, NSDictionary;
@class PDFPage;
@class OAOutlineEntry;

OmniPDF_EXTERN BOOL PDFStorageTimeTrace;

@interface PDFStorage : OFObject
{
    NSData *pdfData;
    unsigned int pdfDataLength;
    const unsigned char *pdfBytes;

    unsigned int scanOffset;

    NSObject *bogusXref;
    NSMutableArray *xrefs;

    NSDictionary *trailerDictionary;
    NSDictionary *catalogDictionary;
    NSDictionary *pagesDictionary;

    int pageCount;
    NSMutableArray *pages;

    OAOutlineEntry *bookmarksOutlineEntry;

    id <PDFEncryptionHandler> *cryptor;
}

// API
- (void) processData;

- (NSArray *)pages;
- (unsigned int) pageCount;

- (PDFPage *)pageFromPageObjectNumber:(int)pageObjectNumber;
- (NSDictionary *)catalogDictionary;
- (OAOutlineEntry *)bookmarksOutlineEntry;

@end
