/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Structure.subproj/PDFSimpleLay.h,v 1.1 1999/02/03 10:26:00 bungi Exp $ */

#import <OmniFoundation/OFObject.h>

@class OFByteSet;
@class OFRTFGenerator;
@class PDFFont;

typedef struct {
    unsigned char	ch;
    double		x;	/* lay space */
} PDFLayCharacter;

#import <Foundation/NSRange.h>
#import <Foundation/NSGeometry.h> /* For NSRect, etc... */
#import <OmniPDF/PDFSelectionModeType.h>
#import <OmniPDF/PDFDrawState.h> /* For PDFMatrix */

@interface PDFSimpleLay : OFObject
{
@public
    PDFLayCharacter	       *buffer;
    int				count;
    int				maxSize;

    PDFFont		       *pdfFont;
    PDFMatrix			firstCharacterMatrix;
    PDFMatrix		        invertedFirstCharacterMatrix;
    PDFMatrix			toLineMatrix;

    double			lastCharacterBeginX; /* lay space */
    double			lastCharacterEndX; /* lay space */

    NSRect			bounds; /* lay space */
    NSRect			frame; /* line space */
    
    NSRange			characterRange;
}

- initWithPDFFont:(PDFFont *)newPDFFont firstCharacterMatrix:(PDFMatrix)matrix;

- (NSRange)rangeOfMousePoint:(NSPoint)mousePoint
   selectionMode:(PDFSelectionMode)selectionMode
   distance:(double *)distance;
- (OFByteSet *)byteSetForCharacterAtRange:(NSRange)range;
- (NSRange)extendRange:(NSRange)range withinSet:(OFByteSet *)set;

- (void)drawCharactersRange:(NSRange)range
   currentPDFFont:(PDFFont **)currentPDFFont;


- (void)addToRTFGenerator:(OFRTFGenerator *)rtfGenerator
    range:(NSRange)range;

@end

static inline void
setBufferSize(void **buffer, int size, int *maxSize, int itemSize)
{
    if (size > *maxSize) {
	if (*maxSize == 0) {
	    *maxSize = size;
	    *buffer = NSZoneMalloc(NULL, *maxSize * itemSize);
	} else {
	    while (*maxSize < size)
		*maxSize *= 2;
	    *buffer = NSZoneRealloc(NULL, *buffer, *maxSize * sizeof(PDFLayCharacter));
	}
    }
}

static inline void
incrementBufferSize(void **buffer, int *size, int *maxSize, int itemSize)
{
    (*size)++;
    setBufferSize(buffer, *size, maxSize, itemSize);
}

static inline double
squaredDistanceBetweenPoints(NSPoint p1, NSPoint p2)
{
    return (p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y);
}

static inline double
squared(double x1, double x2)
{
    return (x1-x2)*(x1-x2);
}
