// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/PDFProgressPanelController.h,v 1.1 1999/02/03 10:25:24 bungi Exp $

#import <OmniFoundation/OFObject.h>
#import <AppKit/NSNibDeclarations.h> // For IBAction
#import <AppKit/NSApplication.h>     // For NSModalSession

@class NSPanel, NSTextField;

@interface PDFProgressPanelController : OFObject
{
    IBOutlet NSPanel        *progressPanel;
    IBOutlet NSTextField    *progressTitleTextField;
    IBOutlet NSTextField    *progressNumberTextField;

    NSModalSession           progressModalSession;
}

+ (PDFProgressPanelController *) sharedProgressPanelController;

- (NSModalSession)runProgressPanelWithTitle:(NSString *)title;
- (void)hideProgressPanel;
- (void)setProgressPageNumber:(int)pageNumber;
- (IBAction)cancelProgressPanel:sender;

@end
