/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/PDFParser.h,v 1.1 1999/02/03 10:25:22 bungi Exp $ */

#import <OmniFoundation/OFObject.h>

@class NSMutableArray;
@class PDFArray;
@class PDFDrawer;
@class PDFInlineImageStream;
@class PDFMark;
@class PDFName;
@class PDFXrefs;
@class PDFObject;

#import <OmniPDF/PDFEncryptionHandlerProtocol.h>

@interface PDFParser : OFObject
{
    NSData                     *pdfData;
    unsigned                    pdfDataLength;
    const unsigned char        *pdfBytes;
    unsigned int                scanOffset;

    PDFArray                   *stack;
    NSMutableArray             *xrefs;

    PDFMark                    *mark;

    NSDictionary	       *nameTranslationDictionary;

    id <PDFSpecificEncryptionHandler,NSObject>   cryptor;
}


+ parserWithData:(NSData *)newData offset:(unsigned)newOffset
   xrefs:(NSMutableArray *)newXrefs;
- initWithData:(NSData *)newData offset:(unsigned)newOffset
 xrefs:(NSMutableArray *)newXrefs;
- initWithData:(NSData *)newData;
- (void)setDecryptor:(id <PDFSpecificEncryptionHandler,NSObject>)anObj;

/**/
 
- (PDFArray *)parseUpToString:(NSString *)endString;
- (PDFArray *)parseUpToString:(NSString *)endString
   drawer:(PDFDrawer *)drawer;
 
- (void)setNameTranslationDictionary:(NSDictionary *)newTranslationDictionary;
- (void)pushMark;
- (PDFInlineImageStream *)parseInlineImageStream;

/**/
- (PDFArray *)stack;
- (NSMutableArray *)xrefs;

@end

#define IS_EOL(buffer, offset) \
    ((buffer)[(offset)] == '\n' || (buffer)[(offset)] == '\r')
#define IS_WHITESPACE(buffer, offset) \
    (isspace((buffer)[(offset)]))

#define EAT_EOL(buffer, offset) \
    {if ((buffer)[(offset)] == '\r') (offset)++; if ((buffer)[(offset)] == '\n') (offset)++;}
#define EAT_WHITESPACE(buffer, offset) \
    {while (IS_WHITESPACE((buffer), (offset))) (offset)++;}

