/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Structure.subproj/PDFPageLays.h,v 1.1 1999/02/03 10:25:59 bungi Exp $ */

#import <OmniFoundation/OFObject.h>

@class NSArray;
@class NSData;
@class NSMutableArray;
@class OFRTFGenerator;
@class PDFDrawState;
@class PDFSimpleLay;
@class PDFLineOfLays;

enum {
    PDFSelectionInvalid = 0xffffffff
};

#import <Foundation/NSRange.h>
#import <Foundation/NSGeometry.h> /* For NSRect, etc... */
#import <OmniPDF/PDFSelectionModeType.h>

@interface PDFPageLays : OFObject
{
    NSMutableArray		*lines;
    PDFSimpleLay		*currentLay;	/* unretained */
    PDFLineOfLays		*currentLine;	/* unretained */

    int			         characterCount;

    NSRange			 selectionRange;
    PDFSelectionMode		 selectionMode;
    
    NSString			*textWithoutReturns;
}

- (NSArray *)lines;

- (void)addLayData:(NSData *)data drawState:(PDFDrawState *)drawState;
- (void)finishLays;

- (int)characterCount;
- (void)setSelectionMode:(PDFSelectionMode)newSelectionMode;
- (NSRange)selectionRange;
- (void)setSelectionRange:(NSRange)newRange;
- (void)clearSelectionRange;
- (NSRange)rangeOfMousePoint:(NSPoint)mousePoint;

- (NSRect)selectedLinesRect;
- (void)drawSelectedLaysInRect:(NSRect)rect;

/* Generating RTF */
- (NSString *)selectedString;
- (NSString *)textWithoutReturns;
- (OFRTFGenerator *)selectionRTFGenerator;
- (void)addToRTFGenerator:(OFRTFGenerator *)rtfGenerator
    range:(NSRange)range;
- (void)addToRTFGenerator:(OFRTFGenerator *)rtfGenerator;

@end
