/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/PDFPage.h,v 1.1 1999/02/03 10:25:21 bungi Exp $ */

#import <OmniFoundation/OFObject.h>

@class NSArray, NSData, NSMutableArray;
@class NSImage;
@class PDFStorage, PDFImage, PDFObject, PDFPageLays, PDFView, PDFXref;

#import <Foundation/NSGeometry.h> // For NSRect, etc...

@interface PDFPage : OFObject
{
    PDFStorage                *pdfStorage;
    unsigned                    pageNumber;
    NSDictionary               *pagesDictionary;

    // lazy
    NSDictionary               *pageDictionary;
    NSRect                      mediaBox;
    NSRect                      cropBox;
    NSRect                      displayBox;
    int                         rotation;
    NSDictionary               *resourceDictionary;
    PDFObject                  *contents;
    NSMutableArray             *annotationsArray;
    unsigned                    objectNumber;
    NSData		       *pageData;

    BOOL			triedToReadThumbnail;
    PDFImage		       *thumbnailPDFImage;
    NSImage		       *thumbnailImage;
    
    PDFPageLays		       *pageLays;
}


+ pageNumber:(unsigned)newPageNumber
   fromPagesDictionary:(NSDictionary *)newPagesDictionary
   pdfStorage:(PDFStorage *)pdfStorage;

- initPageNumber:(unsigned)newPageNumber
  fromPagesDictionary:(NSDictionary *)newPagesDictionary
  pdfStorage:(PDFStorage *)pdfStorage;

- (void)drawInPDFView:(PDFView *)pdfView;
- (PDFPageLays *)readPageLaysInPDFView:(PDFView *)pdfView;

/* */

/* Ivar access */
- (unsigned)pageNumber;
- (unsigned)objectNumber;
- (NSRect)displayBox;
- (int)rotation;
- (NSDictionary *)resourceDictionary;
- (NSArray *)annotationsArray;
- (PDFPageLays *)pageLays;

/* Thumbnail helpers */
- (NSImage *)thumbnailImage;
- (BOOL) triedToReadThumbnail;
- (NSSize)thumbnailSize;
- (NSImage *) forceThumbnailLoad;

@end
