/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Atoms.subproj/PDFObject.h,v 1.1 1999/02/03 10:25:31 bungi Exp $ */

#import <OmniFoundation/OFObject.h>

enum {
    PDF_NOT_XREF = 0xffffffff
};

typedef enum {
    PDF_NOT_AN_OBJECT = 0, PDF_BOOLEAN, PDF_NUMBER, PDF_STRING, PDF_NAME,
    PDF_ARRAY, PDF_DICTIONARY, PDF_STREAM, PDF_NULL,
    PDF_MARK, PDF_XREF, PDF_UNKNOWN
} PDFObjectType;

@class NSData;
@class PDFArray;
@class PDFParser;

#import <OmniPDF/PDFEncryptionHandlerProtocol.h>

@interface PDFObject : OFObject
{

}

/**/

- (int)intValue;
- (float)floatValue;
- (NSData *)data;
- (BOOL)isEqualToString:(NSString *)otherString;
- (NSString *)stringValue;
- dictionary;
- objectForKey:(NSString *)aKey;
- (PDFArray *)array; 
- objectAtIndex:(unsigned)index;


/* Xref compatibility */
- realObject;
- (unsigned)objectNumber;
- (unsigned)generationNumber;

/* Decryption */
- (void)setDecryptor:(id <PDFSpecificEncryptionHandler, NSObject>)anObj;

/* Writing to PS */
- (BOOL)dataMayContainUnprintableCharacters:(NSData *)data;
- (void)writeDataAsHexBytesToPS:(NSData *)data;
- (void)writeToPS;

/**/

- (PDFObjectType)objectType;

@end

#define WORD_BUFFER_SIZE  64
#define BYTES_BUFFER_SIZE (sizeof(unsigned int) * WORD_BUFFER_SIZE)

#define DUMP_BYTES_BUFFER \
    {[data appendBytes:bytesBuffer length:bytesLength]; bytesLength = 0;}
#define ADD_BYTE(ch) \
    {if (bytesLength >= BYTES_BUFFER_SIZE) DUMP_BYTES_BUFFER; bytesBuffer[bytesLength++] = ch;}

