/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Structure.subproj/PDFLineOfLays.h,v 1.1 1999/02/03 10:25:58 bungi Exp $ */

#import <OmniFoundation/OFObject.h>

@class NSMutableArray;
@class OFRTFGenerator;
@class PDFFont;
@class PDFSimpleLay;

#import <Foundation/NSRange.h>
#import <Foundation/NSGeometry.h> /* For NSRect, etc... */

#import <OmniPDF/PDFDrawState.h> /* For PDFMatrix */
#import <OmniPDF/PDFSelectionModeType.h>

@interface PDFLineOfLays : OFObject
{
@public
    NSMutableArray	       *lays;

    PDFMatrix			lineMatrix;
    PDFMatrix		        invertedLineMatrix;

    NSRect			bounds; /* first lay units */
    NSRect			frame; /* device units */
    
    NSRange			characterRange;
}

- initWithCharactersBeforeLine:(int)beforeCount;

- (void)addLay:(PDFSimpleLay *)lay;
- (void)finishLine;

- (NSRect)frame;

- (NSRange)rangeOfMousePoint:(NSPoint)mousePoint
   selectionMode:(PDFSelectionMode)selectionMode
   distance:(double *)distance;

- (void)drawBackgroundRange:(NSRange)range;
- (void)drawCharactersRange:(NSRange)range
   currentPDFFont:(PDFFont **)currentPDFFont;

- (void)addToRTFGenerator:(OFRTFGenerator *)rtfGenerator
    range:(NSRange)range;

@end


#define CHECK_RANGE_BREAK_CONTINUE_FALLTHROUGH(object, range) \
    if (NSMaxRange(range) <= object->characterRange.location) break; \
    if (range.location >= NSMaxRange(object->characterRange)) continue;
