/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/PDFLZWDecoder.h,v 1.1 1999/02/03 10:25:21 bungi Exp $ */

#import <OmniFoundation/OFObject.h>

@class NSData;
@class NSMutableData;

typedef void (*OWLZWOutputMethod)(id, SEL, id);

@interface PDFLZWDecoder : OFObject
{
    NSData                     *lzwData;
    unsigned			lzwDataLength;
    const unsigned char        *lzwBytes;
    
    int                         codeSize;
    int                         bitMask;	/* AND mask for data size */

    id				consumer;
    
    NSMutableData              *outputData;
    unsigned                    outputDataLength;
    unsigned char              *outputBytes;
    
    SEL				outputSelector;
    OWLZWOutputMethod           outputMethod;
    
    int				earlyChange;
}

+ decoderWithInputData:(NSData *)newLZWData codeSize:(int)newCodeSize bitMask:(unsigned)newBitMask earlyChange:(BOOL)newEarlyChange consumer:newConsumer outputChunkSize:(unsigned)newOutputChunkSize outputSelector:(SEL)newOutputSelector;

- initWithInputData:(NSData *)newLZWData
  codeSize:(int)newCodeSize
  bitMask:(unsigned)newBitMask
  earlyChange:(BOOL)newEarlyChange
  consumer:newConsumer
  outputChunkSize:(unsigned)newOutputChunkSize
  outputSelector:(SEL)newOutputSelector;
  
/* NOTE: We should have another init method that takes makes callbacks for more data instead, or takes a data stream.  Something for when we don't have the full input buffer when we start, and we want to process as we go */

- (void)process;

@end
