/* private $Header: /Network/Source/CVS/OmniGroup/OmniPDF/Framework/Resources.subproj/PDFImage.h,v 1.1 1999/02/03 10:25:55 bungi Exp $ */

#import <OmniPDF/PDFXObject.h>

@class NSImage;
@class PDFStream;
@class PDFColorSpace;
@class PDFDictionary;

#import <OmniPDF/PDFDrawState.h>

@interface PDFImage : PDFXObject
{
    int                         width;
    int                         height;
    int                         bitsPerComponent;
    float                       decodeFloatArray[8];
    int                         decodeLength;
    PDFColorSpace	       *colorSpace;
    BOOL			shouldInterpolate;
    BOOL			isImageMask;
    
    BOOL			isBadImage;
    
    NSImage		       *image;
}

+ imageFromStream:(PDFStream *)stream;
- initFromStream:(PDFStream *)stream;

- (void)executeInState:(PDFDrawState *)drawState
	isInline:(BOOL)isInline;
- (BOOL)isGood;

- (NSImage *)image;
- (NSSize)size;

@end
